--This return function is used to
-- retrieve the soundID from the global function contained in the file ZomboWinAnimationAddonSFXBackgroundShared.lua
-- stop the soundID that is playing in a loop
-- and empty the global content value by replacing it with a new nil

--Note : require must have as path relative to the directory 'client' or 'shared' a / between the directory ZomboWin and ZomboWinAnimationAddonSFXBackgroundShared
-- and especially not a .  ("ZomboWin.ZomboWinAnimationAddonSFXBackgroundShared" will give an error 'attempted index: soundID of non-table')

return function(action, parameter)
    local success, shared = pcall(require, "ZomboWin/ZomboWinAnimationAddonSFXBackgroundShared")
    if not success then
        print("[ZomboWinAddon] Failed to require ZomboWinAnimationAddonSFXBackgroundShared")
        return
    end

    local player = action and action.getCharacter and action:getCharacter() or getPlayer()
    if player and shared.soundIDs then
        for _, id in ipairs(shared.soundIDs) do
            player:stopOrTriggerSound(id)
        end
        shared.soundIDs = {} -- Empty the list after
        print("[ZomboWinAddon] All sounds stopped successfully.")
    else
        print("[ZomboWinAddon] No sound to stop")
    end
end